/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.AbstractSysCommand;
import exceptions.LowWeightException;
import exceptions.NoSuchCommandException;
import java.util.Hashtable;

public class SysCommandManager {
    protected final Hashtable<String, AbstractSysCommand> table = new Hashtable();

    public AbstractSysCommand getCommand(String key) throws NoSuchCommandException {
        AbstractSysCommand command = this.table.get(key.toLowerCase());
        if (command != null) {
            return command;
        }
        throw new NoSuchCommandException(key);
    }

    public void processCommand(String key) throws NoSuchCommandException, LowWeightException {
        this.getCommand(key).execute(new String[0]);
    }

    public abstract class SysCommand
    extends AbstractSysCommand {
        public SysCommand(String key, String icon, int mask, int keyChar) {
            super(key.toLowerCase(), icon, mask, keyChar);
            SysCommandManager.this.table.put(key, this);
        }

        public SysCommand(String key, String icon) {
            this(key, icon, 0, -1);
        }
    }
}

