/*
 * Decompiled with CFR 0.152.
 */
package apps;

import exceptions.LowWeightException;
import files.Translator;
import gui.IconFactory;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public abstract class AbstractSysCommand {
    protected String key;
    protected Icon icon;
    protected KeyStroke keyStroke = null;
    public static String directory;

    public AbstractSysCommand(String key, String icon, int mask, int keyChar) {
        this.key = key;
        URL url = this.getClass().getResource(String.valueOf(IconFactory.directory) + icon + ".png");
        if (url != null) {
            this.icon = new ImageIcon(url, icon);
        }
        if (keyChar != -1) {
            this.keyStroke = KeyStroke.getKeyStroke(keyChar, mask);
        }
    }

    public AbstractSysCommand(String key, String icon) {
        this(key, icon, 0, -1);
    }

    public abstract void execute(String ... var1) throws LowWeightException;

    public Icon getIcon() {
        return this.icon;
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public String getText() {
        return Translator.get(this.key);
    }

    public String getToolTipText() {
        return Translator.get(String.valueOf(this.key) + ".toolTipText");
    }

    public String getKey() {
        return this.key;
    }
}

