/*
 * Decompiled with CFR 0.152.
 */
package apps;

import apps.FileFilter2;
import apps.MyLookAndFeel;
import apps.SysCommandManager;
import exceptions.LowWeightException;
import exceptions.NoSuchCommandException;
import files.CSSFile;
import files.Translator;
import gui.CursorFactory;
import gui.IconFactory;
import gui.SFrame;
import gui.SMenuBar;
import gui.SToolBar;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class AbstractApplication {
    public final String name;
    public final String title;
    public final String cfgDir;
    protected final SysCommandManager sysCommandManager;
    protected SFrame frame;
    protected String extension = null;
    protected String[] admissibleExtensions;
    protected SMenuBar menuBar;
    protected SToolBar toolBar;
    private File workingFile;
    protected static final int CTRL = 128;
    protected static final int SHIFT = 64;
    protected static final int ALT = 512;

    public AbstractApplication(String name, String title, String cfgDir) {
        this.name = name;
        this.title = title;
        this.cfgDir = cfgDir;
        this.workingFile = null;
        CursorFactory.directory = String.valueOf(cfgDir) + "cursor/";
        IconFactory.directory = String.valueOf(cfgDir) + "icon/";
        Translator.build(this.getClass().getResource(String.valueOf(cfgDir) + title + ".csv"));
        try {
            URL url = this.getClass().getResource(String.valueOf(cfgDir) + "style.css");
            CSSFile file = new CSSFile(url);
            file.addRulesToHTMLEditorKit();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        this.sysCommandManager = new SysCommandManager();
        this.registerNewCommands();
        this.menuBar = new SMenuBar(this, this.getClass().getResource(String.valueOf(cfgDir) + title + ".menu"));
        this.toolBar = new SToolBar(this, this.getClass().getResource(String.valueOf(cfgDir) + title + ".tool"), 0, true);
        this.frame = new SFrame(title, this.menuBar, this.toolBar);
        this.updateFrameTitle();
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AbstractApplication.this.quit();
            }
        });
        MyLookAndFeel.initUIManager();
        SwingUtilities.updateComponentTreeUI(this.frame);
    }

    protected void setWorkingFile(File file) {
        this.workingFile = file;
        this.updateFrameTitle();
    }

    private void updateFrameTitle() {
        if (this.workingFile == null) {
            this.frame.setTitle(String.valueOf(this.name) + " - " + Translator.get("untitled"));
        } else {
            this.frame.setTitle(String.valueOf(this.name) + " - " + this.workingFile.getName());
        }
        this.frame.validate();
    }

    protected void registerNewCommands() {
        SysCommandManager sysCommandManager = this.sysCommandManager;
        sysCommandManager.getClass();
        new SysCommandManager.SysCommand(sysCommandManager, "new", "document-new", 128, 78){

            public void execute(String ... args) {
                AbstractApplication.this.newFrame();
            }
        };
        SysCommandManager sysCommandManager2 = this.sysCommandManager;
        sysCommandManager2.getClass();
        new SysCommandManager.SysCommand(sysCommandManager2, "load", "document-open", 128, 79){

            public void execute(String ... args) {
                AbstractApplication.this.load();
            }
        };
        SysCommandManager sysCommandManager3 = this.sysCommandManager;
        sysCommandManager3.getClass();
        new SysCommandManager.SysCommand(sysCommandManager3, "save", "document-save", 128, 83){

            public void execute(String ... args) {
                if (AbstractApplication.this.workingFile == null) {
                    AbstractApplication.this.save();
                } else {
                    AbstractApplication.this.save(AbstractApplication.this.workingFile);
                }
            }
        };
        SysCommandManager sysCommandManager4 = this.sysCommandManager;
        sysCommandManager4.getClass();
        new SysCommandManager.SysCommand(sysCommandManager4, "saveas", "document-save-as"){

            public void execute(String ... args) {
                AbstractApplication.this.save();
            }
        };
        SysCommandManager sysCommandManager5 = this.sysCommandManager;
        sysCommandManager5.getClass();
        new SysCommandManager.SysCommand(sysCommandManager5, "quit", "system-log-out", 128, 81){

            public void execute(String ... args) {
                AbstractApplication.this.quit();
            }
        };
    }

    public SysCommandManager getSysCommandManager() {
        return this.sysCommandManager;
    }

    public void load() {
        int returnVal;
        int confirm;
        if (this.hasBeenModified() && (confirm = JOptionPane.showConfirmDialog(this.frame, Translator.get("saveCurrentFile"), Translator.get("open"), 0, 3)) == 0) {
            try {
                this.sysCommandManager.processCommand("save");
            }
            catch (NoSuchCommandException e) {
                e.printStackTrace();
            }
            catch (LowWeightException e) {
                e.printStackTrace();
            }
        }
        JFileChooser chooser = new JFileChooser();
        FileFilter2 filter = new FileFilter2(this.getFileDescription(), this.admissibleExtensions);
        chooser.setDialogTitle(Translator.get("load"));
        chooser.setFileFilter(filter);
        if (this.workingFile != null) {
            chooser.setCurrentDirectory(this.workingFile.getParentFile());
        }
        if ((returnVal = chooser.showOpenDialog(this.frame)) == 0) {
            this.setWorkingFile(chooser.getSelectedFile());
            this.load(this.workingFile);
        }
    }

    public boolean save() {
        JFileChooser chooser = new JFileChooser();
        FileFilter2 filter = new FileFilter2(this.getFileDescription(), this.admissibleExtensions);
        chooser.setFileFilter(filter);
        chooser.setDialogTitle(Translator.get("saveas"));
        chooser.setApproveButtonText(Translator.get("save"));
        int returnVal = chooser.showSaveDialog(this.frame);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            if (!file.getName().endsWith(this.extension)) {
                file = new File(String.valueOf(file.getAbsolutePath()) + this.extension);
            }
            if (file.isFile()) {
                int confirm = JOptionPane.showConfirmDialog(this.frame, Translator.get("confirm.replaceFile"), Translator.get("confirm"), 0, 3);
                if (confirm == 0) {
                    this.setWorkingFile(file);
                    return this.save(this.workingFile);
                }
                return this.save();
            }
            this.setWorkingFile(file);
            return this.save(this.workingFile);
        }
        return false;
    }

    protected void quit() {
        if (!this.hasBeenModified()) {
            this.frame.dispose();
            return;
        }
        int confirm = JOptionPane.showConfirmDialog(this.frame, Translator.get("confirm.quit"), Translator.get("confirm"), 1, 3);
        switch (confirm) {
            case 0: {
                boolean b = this.workingFile != null ? this.save(this.workingFile) : this.save();
                if (!b) break;
                this.frame.dispose();
                break;
            }
            case 1: {
                this.frame.dispose();
                break;
            }
        }
    }

    protected abstract String getFileDescription();

    protected abstract void newFrame();

    protected abstract void load(File var1);

    protected abstract boolean save(File var1);

    protected abstract boolean hasBeenModified();

    public SFrame getFrame() {
        return this.frame;
    }

    protected void setButtonEnabled(String name, boolean b) {
        for (JButton button : this.toolBar.getButtons()) {
            if (!button.getActionCommand().equals(name)) continue;
            button.setEnabled(b);
        }
        for (JMenuItem item : this.menuBar.getJMenuItems()) {
            if (!item.getActionCommand().equals(name)) continue;
            item.setEnabled(b);
        }
    }
}

